<?php
// اسکریپت به‌روزرسانی دیتابیس برای قابلیت تغییر امضا

// اتصال به دیتابیس
require_once 'config.php';
$db = new mysqli('localhost', $databaseUser, $databasePass, $databaseName);

if ($db->connect_error) {
    die("خطا در اتصال به دیتابیس: " . $db->connect_error);
}

// بررسی وجود ستون‌های مورد نیاز در جدول settings
$check_columns = $db->query("SHOW COLUMNS FROM `settings` LIKE 'columnOne'");
if ($check_columns->num_rows == 0) {
    // اضافه کردن ستون columnOne اگر وجود ندارد
    $db->query("ALTER TABLE `settings` ADD COLUMN `columnOne` TEXT NULL AFTER `type_id`");
    echo "ستون columnOne به جدول settings اضافه شد.<br>";
}

// بررسی وجود رکوردهای مربوط به تنظیمات امضا
$signature_types = ['signature', 'signature_from', 'signature_to'];
$admin_result = $db->query("SELECT `from_id` FROM `admin`");

if ($admin_result->num_rows > 0) {
    echo "شروع به‌روزرسانی تنظیمات امضا برای ادمین‌ها...<br>";
    
    while ($admin = $admin_result->fetch_assoc()) {
        $admin_id = $admin['from_id'];
        
        foreach ($signature_types as $type) {
            // بررسی وجود رکورد برای هر نوع تنظیم
            $check = $db->query("SELECT * FROM `settings` WHERE `type` = '$type' AND `from_id` = '$admin_id'");
            
            if ($check->num_rows == 0) {
                // مقدار پیش‌فرض برای هر نوع تنظیم
                $default_value = '';
                $default_type_id = 'inactive';
                
                if ($type == 'signature') {
                    // برای نوع signature فقط type_id نیاز است
                    $db->query("INSERT INTO `settings` (`from_id`, `type`, `type_id`) VALUES ('$admin_id', '$type', '$default_type_id')");
                } else {
                    // برای انواع دیگر هم type_id و هم columnOne نیاز است
                    $db->query("INSERT INTO `settings` (`from_id`, `type`, `type_id`, `columnOne`) VALUES ('$admin_id', '$type', '$default_type_id', '$default_value')");
                }
                
                echo "تنظیمات $type برای ادمین $admin_id ایجاد شد.<br>";
            } else {
                echo "تنظیمات $type برای ادمین $admin_id از قبل وجود دارد.<br>";
            }
        }
    }
    
    echo "به‌روزرسانی تنظیمات امضا با موفقیت انجام شد.<br>";
} else {
    echo "هیچ ادمینی در سیستم یافت نشد.<br>";
}

$db->close();
echo "عملیات به‌روزرسانی دیتابیس با موفقیت به پایان رسید.<br>";
?>